---
generated_at: 2026-02-04 10:15:00
metrics:
  claims_total: 17
  claims_with_evidence: 17
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：4-シェルモード（shell>）

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：17 / 17、根拠なし：0
- 優先レビュー（高）
  1. **Windows環境でのコマンド実行**: Windows固有の処理パスの確認
  2. **パイプライン処理の詳細**: pipeline機能の具体的な使用方法の確認
  3. **ShellCompletionProviderの補完範囲**: ファイルパス以外の補完対応確認

## 2) 参照した情報（Evidence一覧）

- E-01: `base/client.jl` 34-79行 - repl_cmd()関数
- E-02: `stdlib/REPL/src/REPL.jl` 1316-1330行 - shell_modeのPrompt設定
- E-03: `stdlib/REPL/src/REPL.jl` 115行 - SHELL_PROMPT定数
- E-04: `stdlib/REPL/src/REPL.jl` 1200-1228行 - mode_keymap()
- E-05: `docs/code-to-docs/画面遷移図.md` - 画面遷移定義
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ;キーで行頭入力時にシェルモードに遷移する | E-02, E-05 | ○ |
| C-02 | プロンプトが「shell>」である | E-03 | ○ |
| C-03 | Base.repl_cmd()がコマンド実行のメインロジックである | E-01 | ○ |
| C-04 | cdコマンドが特別扱いされる | E-01 (40-62行) | ○ |
| C-05 | cd -でOLDPWDに移動する | E-01 (45-49行) | ○ |
| C-06 | cd引数なしでhomedir()に移動する | E-01 (52行) | ○ |
| C-07 | cd引数2つ以上でArgumentError | E-01 (41-42行) | ○ |
| C-08 | 移動前ディレクトリをENV["OLDPWD"]に保存する | E-01 (55行) | ○ |
| C-09 | expanduser()で引数を展開する | E-01 (36行) | ○ |
| C-10 | ignorestatus()でコマンドを実行する | E-01 (70行) | ○ |
| C-11 | JULIA_SHELL→SHELL→/bin/shの優先順位でシェルを選択する | E-01 (65行) | ○ |
| C-12 | sticky=trueでコマンド実行後もシェルモード維持 | E-02 (1330行) | ○ |
| C-13 | BackspaceまたはCtrl+CでJuliaプロンプトに戻る | E-04, E-05 | ○ |
| C-14 | on_doneでshell_parse→cmd_gen→repl_cmdの呼び出しチェーン | E-02 (1325-1329行) | ○ |
| C-15 | ShellCompletionProviderが設定される | E-02 (1321行) | ○ |
| C-16 | コマンド実行失敗時にdisplay_errorでエラー表示 | E-01 (73-76行) | ○ |
| C-17 | 6種類の関連機能が存在する | E-06 | ○ |

## 4) 不足情報（Unknown / Missing）
- 全ての主張に根拠が確認された

## 5) リスクフラグ（レビュー観点）
- 1: 中リスク - シェルコマンド実行はOSレベルの操作を伴うため、セキュリティ観点の確認が推奨
- 0: 低リスク - cdコマンドの特別処理は明確に実装されている

## 6) レビュアーチェックリスト（最小）
- [ ] repl_cmd()のcdコマンド処理（引数なし、引数1つ、cd -、引数2つ以上）が正しいか確認
- [ ] シェル選択優先順位（JULIA_SHELL→SHELL→/bin/sh）が正しいか確認
- [ ] sticky=trueの動作（コマンド実行後もシェルモード維持）が正しく記述されているか確認
